/********************************************
; File: FOUNDATION.h
;
; Copyright Marc Wolfgram, 1991, 1992
; All Rights Reserved
;
; last revised:   7/10/93
********************************************/
#ifndef __TYPES__
#include <TYPES.h>
#endif

#ifndef __GSOS__
#include <GSOS.h>
#endif

#ifndef __QUICKDRAW__
#include <QUICKDRAW.h>
#endif

#ifndef __RESOURCES__
#include <resources.h>
#endif

#ifndef __FOUNDATION__
#define __FOUNDATION__

void    fAddPrivateData2(GrafPortPtr, long, word, handle, word, word, long);
long    fAddResource2(word, long, handle, word, word, char *);
handle  fBuildLinkHand2(word, long, word, word *);
word    fColorPalette2(word, word, word, word, word, word, long, word);
long    fCopyResource2(word, long, word, word, word, word, char *);
long    fCountResources2(word, word);
void    fDetachResource2(word, long, word);
void    fDisposeLinkHand2(handle);
handle  fExtendLinkHand2(handle, word, long, word, long, word *);
handle  fFindHostLink2(word, long, word *, long *, word *, word *);
long    fGetEditorStatus2(word, long);
handle  fGetFileName2(void);
long    fGetIndResource2(word, long, word);
word    fGetKernalID2(void);
handle  fGetPrivateData2(GrafPortPtr, long *, word *);
word    fGetResourceAttr2(word, long, word);
void    fGetResourceName2(word, long, char *);
long    fGetResourceSize2(word, long, word);
void    fGetStdTypeName2(word, char *);
void    fGetWindowTitle2(word, long, char *);
handle  fLoadFileData2(long, long, long, long);
handle  fLoadResource2(word, long, handle, word *, word, char *);
handle  fLoadScrap2(word *, long *, word, word *);
void    fMarquee2(word , GrafPortPtr, rgnListHndl);
void    fQueryLinkHand2(word, Handle, word *, long *, word *, long *, word *, word *);
void    fRelPrivateData2(GrafPortPtr);
void    fReleaseResource2(word, long, word);
void    fRemoveResource2(word, long, word);
void    fRequestEdit2(word, long, handle, word);
void    fResourceConverter2(word, long, word);
void    fSaveScrap2(word, long, handle, word);
void    fSelectorMenu2(word, long, handle, word, word);
void    fSelectorRequest2(word, long, word);
void    fSetPrivateData2(GrafPortPtr, long, word, handle);
word    fSetResourceAttr2(word, long, word, word);
long    fSetResourceID2(word, long, long, word);
void    fSetResourceName2(word, long, char *);
handle  fSpecialMagic2(word, long, word, word);
void    fSpinCursor2(void);
long    fUniqueResourceID2(word, word);
void    fWriteResource2(word, long, word);

struct rgnList {
    word        index,
                count;
    RegionHndl  list[1];
};
typedef struct rgnList rgnList, *rgnListP, **rgnListHndl;

/* fFlag bits */

#define F_UNDO          0x0001
#define F_CLIP          0x0002
#define F_CLEAR         0x0004
#define F_PRINT         0x0008
#define F_SELECT        0x0010
#define F_HELPAPPLY     0x0040
#define F_MENUAPPLY     0x0080
#define F_OPENSILENT    0x0100
#define F_OPENDATA      0x0200
#define F_REMSELECTOR   0x0400
#define F_HEXEDIT       0x0800
#define F_SCRIPTEDIT    0x1000
#define F_PAGESETUP     0x2000
#define F_640MODE       0x4000
#define F_ACTIVATE      0x8000

/*
    The following structures are defined for the Foundation REM entry blocks
    ------------------------------------------------------------------------
    REM_OPEN
 */
struct fOpenRec {
    word    resType;
    long    resID;
    word    fFlag;          /* 0x0200 Data valid, 0x0100 Silent */
    Handle  Data;
    Pointer wColorPtr;
};
typedef struct fOpenRec fOpenRec, *fOpenRecPtr;

/*
    REM_CLOSE
    REM_WRITE
    REM_PRINT
 */
struct fCloseRec {
    word    resType;
    long    resID;
    word    fFlag;          /* 0x4000 640 mode */
    Pointer windowPtr;
};
typedef struct fCloseRec fCloseRec, *fCloseRecPtr;

/*
    REM_EVENT
 */
struct fEventRec {
    word    resType;
    long    resID;
    word    fFlag,
            taskCode;
};
typedef struct fEventRec fEventRec, *fEventRecPtr;

/*
    REM_ACTIVATE
 */
struct fActivateRec {
    word    resType;
    long    resID;
    word    fFlag;          /* 0x8000 bit is activate */
    Handle  linkHand;       /* null if no link references */
};
typedef struct fActivateRec fActivateRec, *fActivateRecPtr;

/*
    REM_GETLINK
 */
struct fLinkRec {
    word    resType;
    long    resID;
    word    resFileID;      /* null if current workfile */
    Handle  linkHand;
};
typedef struct fLinkRec fLinkRec, *fLinkRecPtr;

/*
    REM_VIDMODE
 */
struct fVidModeRec {
    word    resType;
    long    resID;
    word    fFlag;          /* 0x4000 640 mode */
    Pointer windowPtr,
            wColorPtr;
};
typedef struct fVidModeRec fVidModeRec, *fVidModeRecPtr;

/*
    REM_STARTUP
    REM_SHUTDOWN
 */
struct fStartStopRec {
    word    edUserID,
            edResFileID,
            shResFileID,
            fdResFileID;
};
typedef struct fStartStopRec fStartStopRec, *fStartStopRecPtr;

/*
    The following structures are defined for the Foundation CallBack commands
    -------------------------------------------------------------------------
    fAddResource
    fLoadResource
    fGetResourceAttr
    fLoadScrap
    fRequestEdit
    fSaveScrap
    fSelectorMenu
    fSelectorRequest
    fSetResourceAttr
    fSpecialMagic
 */
struct fResDataRec {
    word    pCount,
            resType;
    long    resID;
    Handle  resData;
    word    special,
            resFileID;
    Pointer resName;
};
typedef struct fResDataRec fResDataRec, *fResDataRecPtr;

/*
    fCountResources
    fGetIndResource
    fGetResourceSize
    fSetResourceID
 */
struct fResData2Rec {
    word    pCount,
            resType;
    long    resID,
            result;
    word    resFileID;
};
typedef struct fResData2Rec fResData2Rec, *fResData2RecPtr;

/*
    fRemoveResource
    fReleaseResource
    fDetachResource
    fWriteResource
    fUniqueResourceID
 */
struct fResRefRec {
    word    pCount,
            resType;
    long    resID;
    word    resFileID;
};
typedef struct fResRefRec fResRefRec, *fResRefRecPtr;

/*
    fGetStdTypeName
    fGetResourceName
    fSetResourceName
    fGetWindowTitle
 */
struct fResNameRec {
    word    pCount,
            resType;
    long    resID;
    char   *resName; /* pascal string */
};
typedef struct fResNameRec fResNameRec, *fResNameRecPtr;

/*
    fBuildLinkHand
    fDisposeLinkHand
    fExtendLinkHand
    fFindHostLink
    fQueryLinkHand
 */
struct fResLinkRec {
    word    pCount,
            index;
    Handle  linkHand;
    word    hostType;
    long    hostID;
    word    resType;
    long    resID;
    word	resCheck,
            resFileID;
};
typedef struct fResLinkRec fResLinkRec, *fResLinkRecPtr;

/*
    fGetFileName
    fLoadFileData
 */
struct fLoadFileRec {
    word    pCount;
    Handle  fileData;
    long    sfGet2ReplyRecPtr,
            sfGet2PromptRefPtr,
            sfGet2FileTypeRecPtr,
            sfGet2FilterProcPtr;
};
typedef struct fLoadFileRec fLoadFileRec, *fLoadFileRecPtr;

/*
    fGetPrivateData
    fSetPrivateData
 */
struct fPrivateDataRec {
    word    pCount;
    Pointer winPtr;
    long    remTaskMask;
    word    remSignature;
    Handle  Data;
    word    groupSignature, /* init only */
            resType;        /* init only */
    long    resID;          /* init only */
};
typedef struct fPrivateDataRec fPrivateDataRec, *fPrivateDataRecPtr;

/*
    fResourceConverter
 */
struct fResConverterRec {
    word    pCount,
            resType;
    long    converterProc;
    word    logFlags;
};
typedef struct fResConverterRec fResConverterRec, *fResConverterRecPtr;

/*
    fCopyResource
 */
struct fResCopyRec {
    word    pCount,
            resType;
    long    resID,
            newID;
    word    attr,
            resFileID,
            newFileID;
    Pointer resName;
};
typedef struct fResCopyRec fResCopyRec, *fResCopyRecPtr;

/*
    fMarquee
 */
struct fMarqueeRec {
    word        pCount,
                action;
    Pointer     windowPtr;
    rgnListHndl rgnListHand;
};
typedef struct fMarqueeRec fMarqueeRec, *fMarqueeRecPtr;

/*
    fColorPalette
 */
struct fColorRec {
    word    pCount;         /* 2 (1.0 & up) 7 or 8 (1.0.2 & up) */
    Point   Loc;
    word    Color;
    word    Row;
    word    Col;            /* msb set for silent run to get pict */
    word    Mode;
    long    resID;
    word    resFileID;
    handle  picture;
};
typedef struct fColorRec fColorRec, *fColorRecPtr;

/*
    The following structures are defined for the REM preference resource 0x7ffb
    ---------------------------------------------------------------------------
*/
struct remPrefRef {
    word    resTag,
            resType;
    long    resID;
};
typedef struct remPrefRef remRef, *remRefPtr;

struct remPrefRes {
    remRef  ref[1];
};
typedef struct remPrefRes *remPrefPtr, **remPrefHndl;

/*
    The following defines provide Foundation CallBack entry access
    --------------------------------------------------------------
*/
extern pascal word FSTACK();

#define fAddPrivateData(pBlockPtr) FSTACK(26,pBlockPtr)
#define fAddResource(pBlockPtr) FSTACK(1,pBlockPtr)
#define fBuildLinkHand(pBlockPtr) FSTACK(11,pBlockPtr)
#define fColorPalette(pBlockPtr) FSTACK(39,pBlockPtr)
#define fCopyResource(pBlockPtr) FSTACK(25,pBlockPtr)
#define fCountResources(pBlockPtr) FSTACK(18,pBlockPtr)
#define fDetachResource(pBlockPtr) FSTACK(5,pBlockPtr)
#define fDisposeLinkHand(pBlockPtr) FSTACK(28,pBlockPtr)
#define fExtendLinkHand(pBlockPtr) FSTACK(10,pBlockPtr)
#define fFindHostLink(pBlockPtr) FSTACK(36,pBlockPtr)
#define fGetEditorStatus(pBlockPtr) FSTACK(33,pBlockPtr)
#define fGetFileName(pBlockPtr) FSTACK(41,pBlockPtr)
#define fGetIndResource(pBlockPtr) FSTACK(19,pBlockPtr)
#define fGetKernalID() FSTACK(40, 0L)
#define fGetPrivateData(pBlockPtr) FSTACK(15,pBlockPtr)
#define fGetResourceAttr(pBlockPtr) FSTACK(22,pBlockPtr)
#define fGetResourceName(pBlockPtr) FSTACK(8,pBlockPtr)
#define fGetResourceSize(pBlockPtr) FSTACK(20,pBlockPtr)
#define fGetStdTypeName(pBlockPtr) FSTACK(7,pBlockPtr)
#define fGetWindowTitle(pBlockPtr) FSTACK(29,pBlockPtr)
#define fLoadFileData(pBlockPtr) FSTACK(13,pBlockPtr)
#define fLoadResource(pBlockPtr) FSTACK(3,pBlockPtr)
#define fLoadScrap(pBlockPtr) FSTACK(31,pBlockPtr)
#define fMarquee(pBlockPtr) FSTACK(38,pBlockPtr)
#define fQueryLinkHand(pBlockPtr) FSTACK(12,pBlockPtr)
#define fRelPrivateData(pBlockPtr) FSTACK(27,pBlockPtr)
#define fReleaseResource(pBlockPtr) FSTACK(4,pBlockPtr)
#define fRemoveResource(pBlockPtr) FSTACK(2,pBlockPtr)
#define fRequestEdit(pBlockPtr) FSTACK(14,pBlockPtr)
#define fResourceConverter(pBlockPtr) FSTACK(24,pBlockPtr)
#define fSaveScrap(pBlockPtr) FSTACK(32,pBlockPtr)
#define fSelectorMenu(pBlockPtr) FSTACK(35,pBlockPtr)
#define fSelectorRequest(pBlockPtr) FSTACK(34,pBlockPtr)
#define fSetPrivateData(pBlockPtr) FSTACK(16,pBlockPtr)
#define fSetResourceAttr(pBlockPtr) FSTACK(23,pBlockPtr)
#define fSetResourceID(pBlockPtr) FSTACK(21,pBlockPtr)
#define fSetResourceName(pBlockPtr) FSTACK(9,pBlockPtr)
#define fSpecialMagic(pBlockPtr) FSTACK(30,pBlockPtr)
#define fSpinCursor() FSTACK(37, 0L)
#define fUniqueResourceID(pBlockPtr) FSTACK(17,pBlockPtr)
#define fWriteResource(pBlockPtr) FSTACK(6,pBlockPtr)

#endif
